
/* AT90USB162 */

#include "defines.h"
#include <avr/io.h>
#include "usb_drv.h"

extern void UsbDevInit();
extern void UsbBusyWait();

int main(void) {
  // enable crystal
  CLKPR = _BV(CLKPCE);
  CLKPR = 0;

  // set clock source to crystal
  CKSEL1 |= 15;
  CKSEL0 |= _BV(EXTE);
  while( !(CKSTA&_BV(EXTON)) )
    ;
  CKSEL0 |= _BV(CLKS);
  // turn off internal oscillator
  CKSEL0 &= ~_BV(RCE);

  UsbDevInit();
  UsbDevLaunchDevice(false);
  UsbBusyWait();

  return 0;
}
